
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="page-header">
            <h3 class="page-title">
                <span class="page-title-icon bg-gradient-primary text-white me-2">
                    <i class="mdi mdi-home"></i>
                </span> User Detail
            </h3>
            
        </div>
        <div class="row">
            <div class="col-lg-12 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">User List</h4>
                        </p>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Sr.No</th>
                                    <th>Userid</th>
                                    <th>Name</th>
                                    <th>Mobile</th>
                                    <th>Email</th>
                                    <th>Wallet</th>
                                    <th>Last Recharge</th>
                                    <th>S. Promocode</th>
                                    <th>Promocode</th>
                                    <th>Created</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(count($userlist) > 0): ?>
                                    <?php $__currentLoopData = $userlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><?php echo e(appvalidate($item->id)); ?></td>
                                            <td><?php echo e(appvalidate($item->name)); ?></td>
                                            <td><?php echo e(appvalidate($item->mobile)); ?></td>
                                            <td><?php echo e(appvalidate($item->email)); ?></td>
                                            <td>₹<?php echo e(wallet($item->id)); ?> <span class="mdi mdi-border-color"
                                                    style="cursor: pointer;" onclick="updatewalletbalance('<?php echo e(appvalidate($item->id)); ?>','<?php echo e(wallet($item->id,'num')); ?>')"></span></td>
                                            <td>₹<?php echo e(number_format(lastrecharge($item->id, 'amount'), 2)); ?>

                                                <sub><?php echo e(lastrecharge($item->id, 'created_at') ? dformat(lastrecharge($item->id, 'created_at'), 'd-m-Y') : 'No data found!'); ?></sub>
                                            </td>
                                            <td><?php echo e(appvalidate($item->promocode)); ?></td>
                                            <td><?php echo e(appvalidate($item->id)); ?></td>
                                            <td><?php echo e(dformat($item->created_at, 'd-m-Y')); ?></td>
                                            <td><label
                                                    class="badge badge-<?php echo e(status($item->status, 'user')['color']); ?>"><?php echo e(status($item->status, 'user')['name']); ?></label>
                                            </td>
                                            <td>
                                                <button class="btn btn-sm btn-warning"
                                                    onclick="redirect('user/edit/<?php echo e($item->id); ?>')">edit</button>
                                                <button class="btn btn-sm btn-danger"
                                                    onclick="deleteuser('<?php echo e($item->id); ?>')">Delete</button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="13" class="text-center"> No User found!!</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="walletupdateform" style="display: none;">
        
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">Update wallet</h4>
                <form class="forms-sample" id="updatewallet">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                        <input type="hidden" name="userid" value="" id="updatewalletuserid">
                        <label for="updatewalletamount">Amount</label>
                        <input type="text" class="form-control" id="updatewalletamount" name="amount" placeholder="Enter Amount">
                    </div>
                    <button type="submit" class="btn btn-gradient-primary me-2">Submit</button>
                    <button class="btn btn-light" type="button" onclick="closewalletupdatemodel()">Cancel</button>
                </form>
            </div>
        </div>
        
    </div>
    <!-- content-wrapper ends -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script>
        function deleteuser(id) {
            let form = new FormData();
            form.append('id', id);
            form.append('_token', '<?php echo e(csrf_token()); ?>');
            apex("POST", "<?php echo e(url('admin/api/user/delete')); ?>", form, '', "/admin/user-list", "#");
        }
        $("#updatewallet").on('submit', function(e) {
            e.preventDefault();
        });
        $("#updatewallet").validate({
            submitHandler: function(form) {
                apex("POST", "<?php echo e(url('admin/api/updatewallet')); ?>", new FormData(form), form,
                    "/admin/user-list", "#");
            }
        });
        function updatewalletbalance(userid,amount) {
            $(".walletupdateform").show('fast');
            $("#updatewalletuserid").val(userid);
            $("#updatewalletamount").val(amount);
        }
        function closewalletupdatemodel() {
            $(".walletupdateform").hide('fast');
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('Layout.admindashboard', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ziolfvwj00it/public_html/ludokingstar.com/laravel/resources/views/admin/userlist.blade.php ENDPATH**/ ?>